<?php
header('Content-Type: application/json');
include 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $estado = intval($_POST['estado']);

    $conexion = new conexion();

    // Verifica si ya existe un registro para este estudiante en la nueva tabla
    $verificarSql = "SELECT Id_EstadoFun FROM Profesores WHERE Id_Profesores = ?";
    $verificarStmt = $conexion->conector->prepare($verificarSql);
    $verificarStmt->bind_param("i", $id);
    $verificarStmt->execute();
    $verificarStmt->store_result();

    if ($verificarStmt->num_rows > 0) {
        // Ya existe, actualizamos
        $sql = "UPDATE Profesores SET Id_EstadoFun = ? WHERE Id_Profesores = ?";
        $stmt = $conexion->conector->prepare($sql);
        $stmt->bind_param("ii", $estado, $id);
    } else {
        // No existe, insertamos nuevo
        $sql = "UPDATE Profesores SET Id_EstadoFun = ? WHERE Id_Profesores = ?";
        $stmt = $conexion->conector->prepare($sql);
        $stmt->bind_param("ii", $id, $estado);
    }

    $verificarStmt->close();

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Estado actualizado correctamente']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Error al actualizar el estado']);
    }

    $stmt->close();
    $conexion->conector->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
}
?>
