<?php
include '../routes/conexion.php';
$base = new conexion();
$conexion = $base->conectar();

session_start();

// Ruta al archivo de logs
$logFile = '../routes/logs/loginlogs.txt'; // asegúrate que exista la carpeta 'logs'

function escribirLog($mensaje) {
    global $logFile;
    $fecha = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$fecha] $mensaje\n", FILE_APPEND);
}

// Habilitar errores para desarrollo (quitar en producción)
ini_set('display_errors', 1);
error_reporting(E_ALL);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    escribirLog("Formulario recibido");

    $email = $_POST['username'] ?? '';
    $clave = $_POST['password'] ?? '';

    escribirLog("Email recibido: $email");

    if (!$conexion) {
        escribirLog("Error en la conexión a la base de datos.");
        die("Error en la conexión a la base de datos.");
    }

    $stmt = $conexion->prepare("SELECT * FROM profesores WHERE Email_Fun = ?");
    if (!$stmt) {
        escribirLog("Error al preparar la consulta: " . $conexion->error);
        die("Error al preparar la consulta.");
    }

    $stmt->bind_param("s", $email);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if (!$resultado) {
        escribirLog("Error al ejecutar la consulta: " . $stmt->error);
        die("Error al ejecutar la consulta.");
    }

    if ($resultado->num_rows === 1) {
    $profesor = $resultado->fetch_assoc();
    escribirLog("Usuario encontrado: " . $profesor['Nombre_Fun']);

    // Comparación sin cifrado
    if ($clave === $profesor['password']) {
        escribirLog("Contraseña verificada correctamente. Inicio de sesión exitoso.");
        $_SESSION['profesor'] = $profesor['Nombre_Fun'];
        header("Location: ../views/vistaadmin.php");
        exit();
    } else {
        escribirLog("Contraseña incorrecta.");
        header("Location: ../views/loginerror.php?username=" . urlencode($email));
    }
    } else {
        escribirLog("Correo no encontrado.");
        header("Location: ../views/lognotemail.php");
    }
} else {
    escribirLog("El formulario no fue enviado mediante POST.");
    echo "Error: método de envío incorrecto.";
}
?>
